/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed.cim;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.cim.CimProvider;
import com.ibm.hwmca.fw.managed.cim.ManagedCimErrorIds;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMElement;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMMethod;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;

public abstract class ManagedElementCimProvider
extends CimProvider
implements ManagedCimErrorIds {
    private String providedClassName;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "MngElemCimP");
    private static final String TRACE_MASKT = "XCIMMEPT";
    private static final String TRACE_MASKF = "XCIMMEPF";
    private static final String TRACE_MASKD = "XCIMMEPD";

    protected ManagedElementCimProvider(String providedClassName) {
        Trace.trace(TRACE_MASKT, "<> ManagedElementCimProvider(providedClassName=" + providedClassName + ")");
        this.providedClassName = providedClassName;
    }

    public String getProvidedClassName() {
        return this.providedClassName;
    }

    public Vector enumInstances(CIMObjectPath path, boolean deep, CIMClass cimClass) throws CIMException {
        Trace.trace(TRACE_MASKT, "-> enumInstances(path=" + path + ",deep=" + deep + ",cimClass=" + cimClass.getName() + ")");
        Vector<CIMObjectPath> result = new Vector<CIMObjectPath>();
        try {
            ClassId classId = new ClassId(this.getProvidedClassName());
            Iterator iterator = mom.getInventoryObjectIds(classId).iterator();
            while (iterator.hasNext()) {
                ObjectId id = (ObjectId)iterator.next();
                if (!this.isVisible(id)) continue;
                result.add(ManagedElementCimProvider.objectIdToPath(id));
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 691, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred enumerating instances for " + path));
        }
        Trace.trace(TRACE_MASKT, "<- enumInstances(returns " + result.size() + " instances)");
        return result;
    }

    public Vector enumInstances(CIMObjectPath path, boolean deep, CIMClass cimClass, boolean localOnly) throws CIMException {
        Trace.trace(TRACE_MASKT, "-> enumInstances(path=" + path + ",deep=" + deep + ",cimClass=" + cimClass.getName() + ",localOnly=" + localOnly + ")");
        Vector<CIMInstance> result = new Vector<CIMInstance>();
        try {
            ClassId classId = new ClassId(this.getProvidedClassName());
            Iterator iterator = mom.getInventory(classId).iterator();
            while (iterator.hasNext()) {
                HwmcaObject javaInstance = (HwmcaObject)iterator.next();
                if (!this.isVisible(javaInstance)) continue;
                result.add(this.buildInstance(javaInstance, cimClass, localOnly));
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 691, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred enumerating instances for " + path));
        }
        Trace.trace(TRACE_MASKT, "<- enumInstances(returns " + result.size() + " instances)");
        return result;
    }

    public CIMInstance getInstance(CIMObjectPath path, CIMClass cimClass, boolean localOnly) throws CIMException {
        CIMInstance result;
        Trace.trace(TRACE_MASKT, "-> getInstance(path=" + path + ",cimClass=" + cimClass.getName() + ",localOnly=" + localOnly + ")");
        try {
            HwmcaObject javaInstance = mom.get(ManagedElementCimProvider.objectPathToId(path));
            if (javaInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Object " + path + " does not exist"));
            }
            result = this.buildInstance(javaInstance, cimClass, localOnly);
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 693, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred retrieving the instance for " + path));
        }
        Trace.trace(TRACE_MASKT, "<- getInstance(returns " + result.getName() + ")");
        return result;
    }

    public void setInstance(CIMObjectPath path, CIMInstance instance) throws CIMException {
        Trace.trace(TRACE_MASKT, "-> setInstance(path=" + path + ")");
        try {
            CIMProperty cimProperty = null;
            ObjectId id = ManagedElementCimProvider.objectPathToId(path);
            HwmcaObject javaInstance = mom.get(id);
            if (javaInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Object " + path + " does not exist"));
            }
            CIMClass cimClass = descriptors.findClass(javaInstance.getClass().getName());
            if (cimClass == null) {
                throw new CIMException("CIM_ERR_FAILED", (Object)("Class " + javaInstance + " not found"));
            }
            Iterator iterator = instance.getProperties().iterator();
            while (iterator.hasNext()) {
                try {
                    cimProperty = (CIMProperty)iterator.next();
                    CIMQualifier cimQualifier = cimProperty.getQualifier("WRITE");
                    if (cimQualifier == null || cimQualifier.getValue() != null && !((String)cimQualifier.getValue().getValue()).equalsIgnoreCase("TRUE")) continue;
                    CIMMethod cimMethod = descriptors.findSetMethod(cimClass, cimProperty);
                    if (cimMethod == null) {
                        throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("A set method does not exist for property " + cimProperty.getName()));
                    }
                    Object propertyValue = ManagedElementCimProvider.toJavaValue(cimProperty.getValue());
                    descriptors.invokeMethod(cimMethod, javaInstance, new Object[]{propertyValue});
                }
                catch (CIMException exc) {
                    Trace.trace(TRACE_MASKF, "An error occured setting property " + cimProperty.getName());
                    Trace.trace(TRACE_MASKF, (Object)exc);
                }
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 694, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred setting instance " + path));
        }
        Trace.trace(TRACE_MASKT, "<- setInstance()");
    }

    public CIMValue getPropertyValue(CIMObjectPath path, String originClass, String propertyName) throws CIMException {
        CIMValue result;
        Trace.trace(TRACE_MASKT, "-> getPropertyValue(path=" + path + ",originClass=" + originClass + ",propertyName=" + propertyName + ")");
        try {
            HwmcaObject javaInstance = mom.get(ManagedElementCimProvider.objectPathToId(path));
            if (javaInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Object " + path + " does not exist"));
            }
            result = this.getPropertyValue(javaInstance, originClass, propertyName);
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 688, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred getting property " + propertyName));
        }
        Trace.trace(TRACE_MASKT, "<- getPropertyValue(returns " + result + ")");
        return result;
    }

    public void setPropertyValue(CIMObjectPath path, String originClass, String propertyName, CIMValue newValue) throws CIMException {
        Trace.trace(TRACE_MASKT, "-> setPropertyValue(path=" + path + ",originClass=" + originClass + ",propertyName=" + propertyName + ",newValue=" + newValue + ")");
        try {
            HwmcaObject javaInstance = mom.get(ManagedElementCimProvider.objectPathToId(path));
            if (javaInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Object " + path + " does not exist"));
            }
            this.setPropertyValue(javaInstance, originClass, propertyName, newValue);
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 689, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred setting property " + propertyName));
        }
        Trace.trace(TRACE_MASKT, "<- setPropertyValue()");
    }

    public CIMValue invokeMethod(CIMObjectPath path, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue result;
        Trace.trace(TRACE_MASKT, "-> invokeMethod(path=" + path + ",methodName=" + methodName + ",inParams=" + inParams + ",outParams=" + outParams + ")");
        try {
            HwmcaObject javaInstance = mom.get(ManagedElementCimProvider.objectPathToId(path));
            if (javaInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Object " + path + " does not exist"));
            }
            result = this.invokeMethod(javaInstance, methodName, inParams, outParams);
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 690, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred invoking method " + methodName));
        }
        Trace.trace(TRACE_MASKT, "<- invokeMethod(returns " + result + ")");
        return result;
    }

    protected boolean isVisible(HwmcaObject object) {
        return this.isVisible(object.getObjectId());
    }

    protected boolean isVisible(ObjectId id) {
        return id.getFullClassName().equals(this.getProvidedClassName());
    }

    protected CIMValue getPropertyValue(HwmcaObject javaInstance, String originClass, String propertyName) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> getPropertyValue(javaInstance=" + javaInstance + ",propertyName=" + propertyName + ")");
        CIMValue result = null;
        try {
            if (propertyName.equalsIgnoreCase("Caption")) {
                result = new CIMValue((Object)javaInstance.getUIInfo().getCaption());
            } else if (propertyName.equalsIgnoreCase("Description")) {
                result = new CIMValue((Object)javaInstance.getUIInfo().getCaption());
            } else if (propertyName.equalsIgnoreCase("ElementName")) {
                result = new CIMValue((Object)javaInstance.getUIInfo().getName());
            } else {
                CIMClass cimClass = descriptors.findClass(javaInstance.getClass().getName());
                if (cimClass == null) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)("Class " + javaInstance + " not found"));
                }
                CIMProperty cimProperty = descriptors.findProperty(cimClass, propertyName);
                if (cimProperty == null) {
                    throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", (Object)propertyName);
                }
                CIMMethod cimMethod = descriptors.findGetMethod(cimProperty);
                if (cimMethod == null) {
                    throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("An accessor method does not exist for property " + propertyName));
                }
                Object propertyValue = descriptors.invokeMethod(cimMethod, javaInstance, null);
                result = ManagedElementCimProvider.toCimValue(propertyValue, (CIMElement)cimProperty);
            }
        }
        catch (NoSuchMethodException exc) {
            Trace.trace(TRACE_MASKF, "A get method was not found for property " + propertyName);
            Trace.trace(TRACE_MASKF, exc);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("An accessor method does not exist for property " + propertyName));
        }
        Trace.trace(TRACE_MASKT, "<- getPropertyValue(returns " + result + ")");
        return result;
    }

    protected void setPropertyValue(HwmcaObject javaInstance, String originClass, String propertyName, CIMValue newValue) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> setPropertyValue(javaInstance=" + javaInstance + ")");
        try {
            CIMClass cimClass = descriptors.findClass(javaInstance.getClass().getName());
            if (cimClass == null) {
                throw new CIMException("CIM_ERR_FAILED", (Object)("Class " + javaInstance + " not found"));
            }
            CIMProperty cimProperty = descriptors.findProperty(cimClass, propertyName);
            if (cimProperty == null) {
                throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", (Object)propertyName);
            }
            CIMMethod cimMethod = descriptors.findSetMethod(cimProperty);
            if (cimMethod == null) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("A set method does not exist for property " + propertyName));
            }
            Object[] args = new Object[]{ManagedElementCimProvider.toJavaValue(newValue)};
            descriptors.invokeMethod(cimMethod, javaInstance, args);
        }
        catch (NoSuchMethodException exc) {
            Trace.trace(TRACE_MASKF, "A set method was not found for property " + propertyName);
            Trace.trace(TRACE_MASKF, exc);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("An accessor method does not exist for property " + propertyName));
        }
        Trace.trace(TRACE_MASKT, "<- setPropertyValue()");
    }

    protected CIMValue invokeMethod(HwmcaObject javaInstance, String methodName, Vector inParams, Vector outParams) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> invokeMethod(javaInstance=" + javaInstance + ",methodName=" + methodName + ",inParams=" + inParams + ",outParams=" + outParams + ")");
        CIMValue result = null;
        try {
            CIMClass cimClass = descriptors.findClass(javaInstance.getClass().getName());
            if (cimClass == null) {
                throw new CIMException("CIM_ERR_FAILED", (Object)("Class " + javaInstance + " not found"));
            }
            CIMMethod cimMethod = descriptors.findMethod(cimClass, methodName);
            if (cimMethod == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_FOUND", (Object)("Error finding method " + methodName));
            }
            Object[] args = ManagedElementCimProvider.toJavaValues(inParams);
            Object returnValue = descriptors.invokeMethod(cimMethod, javaInstance, args);
            result = ManagedElementCimProvider.toCimValue(returnValue, (CIMElement)cimMethod);
        }
        catch (NoSuchMethodException exc) {
            Trace.trace(TRACE_MASKF, "Method " + methodName + "was not found");
            Trace.trace(TRACE_MASKF, exc);
            throw new CIMException("CIM_ERR_METHOD_NOT_FOUND", (Object)("Method " + methodName + "was not found"));
        }
        Trace.trace(TRACE_MASKT, "<- invokeMethod(returns " + result + ")");
        return result;
    }

    protected CIMInstance buildInstance(HwmcaObject javaInstance, CIMClass cimClass, boolean localOnly) {
        Trace.trace(TRACE_MASKD, "-> buildInstance(javaInstance=" + javaInstance + ",cimClass=" + cimClass.getName() + ",localOnly=" + localOnly + ")");
        CIMInstance result = cimClass.newInstance();
        CIMClass javaClass = descriptors.findClass(javaInstance.getClass().getName());
        result.setClassName(ManagedElementCimProvider.toCimName((CIMElement)javaClass));
        Vector cimProperties = null;
        CIMProperty cimProperty = null;
        cimProperties = localOnly ? cimClass.getProperties() : cimClass.getAllProperties();
        Vector<CIMProperty> newProperties = new Vector<CIMProperty>();
        Iterator iterator = cimProperties.iterator();
        while (iterator.hasNext()) {
            try {
                cimProperty = (CIMProperty)iterator.next();
                if (localOnly && !cimProperty.getOriginClass().equals(cimClass.getName())) continue;
                CIMValue propertyValue = this.getPropertyValue(javaInstance, cimProperty.getOriginClass(), cimProperty.getName());
                cimProperty.setValue(propertyValue);
                newProperties.add(cimProperty);
            }
            catch (Throwable thrown) {
                Trace.trace(TRACE_MASKF, "An error occurred getting property " + cimProperty.getName());
                Trace.trace(TRACE_MASKF, thrown);
            }
        }
        result.setProperties(newProperties);
        Trace.trace(TRACE_MASKD, result.toString());
        Trace.trace(TRACE_MASKD, "<- buildInstance(returns " + result.getName() + ")");
        return result;
    }
}

